///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK AddScheduleDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
	static HWND BackupWindowTimeBegin_hWnd;
	static HWND BackupWindowTimeEnd_hWnd;
	static HWND StartOnceTime_hWnd;

	static HWND IncrementMinuteUD_hWnd;
	static HWND IncrementMinute_hWnd;

	static HWND IncrementHourUD_hWnd;
	static HWND IncrementHour_hWnd;

	if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
	{
		AddScheduleDialog_hWnd = xHandle;

		SendMessage(AddScheduleDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"Add Schedule");
		SendMessage(AddScheduleDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(100)));

		BackupWindowTimeBegin_hWnd	   = GetDlgItem(AddScheduleDialog_hWnd, 4000);
		BackupWindowTimeEnd_hWnd	   = GetDlgItem(AddScheduleDialog_hWnd, 4001);

        StartOnceTime_hWnd = GetDlgItem(AddScheduleDialog_hWnd, 5000);

		IncrementHour_hWnd	   = GetDlgItem(AddScheduleDialog_hWnd, 2000);
		IncrementHourUD_hWnd   = GetDlgItem(AddScheduleDialog_hWnd, 2001);

		IncrementMinute_hWnd   = GetDlgItem(AddScheduleDialog_hWnd, 3000);
    	IncrementMinuteUD_hWnd = GetDlgItem(AddScheduleDialog_hWnd, 3001);

		SendMessage(IncrementHourUD_hWnd,(UINT)UDM_SETBUDDY, (WPARAM)IncrementHour_hWnd, (LPARAM)NULL);
		SendMessage(IncrementHourUD_hWnd,(UINT)UDM_SETRANGE, (WPARAM)NULL,(LPARAM)MAKELONG(23, 0));

		SendMessage(IncrementMinuteUD_hWnd,(UINT)UDM_SETBUDDY, (WPARAM)IncrementMinute_hWnd, (LPARAM)NULL);
		SendMessage(IncrementMinuteUD_hWnd,(UINT)UDM_SETRANGE, (WPARAM)NULL, (LPARAM)MAKELONG(59, 0));

		SetDlgItemInt(AddScheduleDialog_hWnd, 2000, 1, FALSE);
		SetDlgItemInt(AddScheduleDialog_hWnd, 3000, 0, FALSE);

        CheckAllWeekDays(AddScheduleDialog_hWnd);

        CheckDlgButton(AddScheduleDialog_hWnd, 7000, BST_CHECKED);
        SchedChangeAllOnMultipleRadio(AddScheduleDialog_hWnd, TRUE);
        SchedChangeAllOnSingleRadio(AddScheduleDialog_hWnd, FALSE);

        BOD.Complete   = FALSE;
        SQLOD.Complete = FALSE;

        SetValues();

 		CenterWindow(AddScheduleDialog_hWnd);

		return 0;
	}

	if(xMessage == WM_COMMAND) // Received A Message
	{
		if(wParam == 6000) //- Run multiple times per day check box (Dialog Command)
		{
            SchedChangeAllOnMultipleRadio(AddScheduleDialog_hWnd, FALSE);
            SchedChangeAllOnSingleRadio(AddScheduleDialog_hWnd, TRUE);
            return 0;
		}

		if(wParam == 7000) //- Run once per day check box (Dialog Command)
		{
            SchedChangeAllOnMultipleRadio(AddScheduleDialog_hWnd, TRUE);
            SchedChangeAllOnSingleRadio(AddScheduleDialog_hWnd, FALSE);
            return 0;
        }

        if(wParam == 100) //- Ok (Dialog Command)
		{
            if( IsAtleastOneDayChecked(AddScheduleDialog_hWnd) == FALSE)
            {
                MessageBox(AddScheduleDialog_hWnd, "You must select at least one day.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            BOOL OncePerDay = FALSE;

            if( IsDlgButtonChecked(AddScheduleDialog_hWnd, 7000) == TRUE)
                OncePerDay = TRUE;
            else OncePerDay = FALSE;

            if(BOD.Complete == FALSE)
            {
                MessageBox(AddScheduleDialog_hWnd, "You must set the backup options.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            if(SQLOD.Complete == FALSE)
            {
                MessageBox(AddScheduleDialog_hWnd, "You must set the SQL options.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            int IncrementMinute = CharInt( Get_Text(IncrementMinute_hWnd) );
            int IncrementHour   = CharInt( Get_Text(IncrementHour_hWnd) );

            if(IncrementMinute == 0 && IncrementHour == 0 && OncePerDay == FALSE)
            {
                MessageBox(AddScheduleDialog_hWnd, "The scheduled backup must increment by some value. Hour or minute.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            int ThisSchedule = NextAvailSchedule();

            BT[ThisSchedule].SQLServer        = SQLOD.SQLServer;
            BT[ThisSchedule].Database         = SQLOD.DataBase;
            BT[ThisSchedule].DBDriver         = SQLOD.DBDriver;
            BT[ThisSchedule].Username         = SQLOD.UserName;
            BT[ThisSchedule].Password         = SQLOD.Password;
            BT[ThisSchedule].IsTrusted        = SQLOD.IsTrusted;

            BT[ThisSchedule].Name             = BOD.BackupName;
            BT[ThisSchedule].Description      = BOD.BackupDescription;
            BT[ThisSchedule].Filename         = BOD.BackupFileName;

			SYSTEMTIME Time;
			GetSystemTime(&Time);

            SendMessage(BackupWindowTimeBegin_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &Time);
            BT[ThisSchedule].BackupWindowTimeBegin = TimeToLong(Time.wHour, Time.wMinute, Time.wSecond);

            SendMessage(BackupWindowTimeEnd_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &Time);
            BT[ThisSchedule].BackupWindowTimeEnd = TimeToLong(Time.wHour, Time.wMinute, Time.wSecond);

            SendMessage(StartOnceTime_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &Time);
            BT[ThisSchedule].StartOnceTime = TimeToLong(Time.wHour, Time.wMinute, Time.wSecond);

            BT[ThisSchedule].IncrementHour    = IncrementHour;
            BT[ThisSchedule].IncrementMinute  = IncrementMinute;
            BT[ThisSchedule].ScheduleID       = CurrentScheduleID++;

            BT[ThisSchedule].OnlyRunOnce      = OncePerDay;
            BT[ThisSchedule].OnHold           = FALSE;
            BT[ThisSchedule].Active           = TRUE;
            BT[ThisSchedule].ScheduleSet      = TRUE;

            LoadWeekDaysFromDialogIntoScheduleItem(AddScheduleDialog_hWnd, ThisSchedule);

            NumberOfSetSchedules++;

            CalculateSchedules();
            ListView_DeleteAllItems(SD.ListView_hWnd);
            LoadScheduleIntoDialog();

			EndDialog(AddScheduleDialog_hWnd,0);

			return 0;
		}

		if(wParam==101) //- Cancel (Dialog Command)
		{
			EndDialog(AddScheduleDialog_hWnd,0);
			return 0;
		}

		if(wParam==102) //- Backup Options (Dialog Command)
		{
        	DialogBox(MainInstance, MAKEINTRESOURCE(106), AddScheduleDialog_hWnd, AddBackupOptionsDialog);
			return 0;
		}

		if(wParam==103) //- SQL Options (Dialog Command)
		{
        	DialogBox(MainInstance, MAKEINTRESOURCE(107), AddScheduleDialog_hWnd, AddSQLOptionsDialog);
			return 0;
		}

        if(wParam == 105) //- All Checked (Dialog Command)
        {
            CheckAllWeekDays(AddScheduleDialog_hWnd);
            return 0;
        }

        if(wParam == 106) //- None Checked (Dialog Command)
        {
            UnCheckAllWeekDays(AddScheduleDialog_hWnd);
            return 0;
        }

		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

